{ $HDR$}
{**********************************************************************}
{ Unit archived using Team Coherence                                   }
{ Team Coherence is Copyright 2002 by Quality Software Components      }
{                                                                      }
{ For further information / comments, visit our WEB site at            }
{ http://www.TeamCoherence.com                                         }
{**********************************************************************}
{}
{ $Log:  23944: IdMessageCoderQuotedPrintable.pas 
{
{   Rev 1.0    26/09/2003 01:08:16  CCostelloe
{ Initial version
}
unit IdMessageCoderQuotedPrintable;

interface

//Written by C Costelloe, 23rd September 2003

uses
  Classes,
  Math,
  IdMessageCoder, IdMessage;

  {Note: Decoding handled by IdMessageDecoderMIME}

type
  TIdMessageEncoderQuotedPrintable = class(TIdMessageEncoder)
  public
    procedure Encode(ASrc: TStream; ADest: TStream); override;
  end;
  TIdMessageEncoderInfoQuotedPrintable = class(TIdMessageEncoderInfo)
  public
    constructor Create; override;
  end;

implementation

uses
  IdCoder, IdCoderMIME, IdCoreGlobal, IdException, IdGlobal, IdResourceStrings, IdCoderQuotedPrintable,
  SysUtils, IdCoderHeader;

{ TIdMessageEncoderInfoQuotedPrintable }

constructor TIdMessageEncoderInfoQuotedPrintable.Create;
begin
  inherited;
  FMessageEncoderClass := TIdMessageEncoderQuotedPrintable;
end;

{ TIdMessageEncoderQuotedPrintable }

procedure TIdMessageEncoderQuotedPrintable.Encode(ASrc, ADest: TStream);
var
  s: string;
  LEncoder: TIdEncoderQuotedPrintable;
begin
  LEncoder := TIdEncoderQuotedPrintable.Create(nil); try
    s := LEncoder.Encode(ASrc, ASrc.Size);
    ADest.WriteBuffer(s[1], Length(s));
  finally FreeAndNil(LEncoder); end;
end;

initialization
  TIdMessageEncoderList.RegisterEncoder('QP', TIdMessageEncoderInfoQuotedPrintable.Create);    {Do not Localize}

end.
